<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\validate;
class UploadValidate extends BaseValidate
{

    protected $rule = [
        'image'              => 'fileExt:jpg,jpeg,gif,png,bmp,webp,avif,tga,pdf|fileSize:5242880',
        'video'              => 'fileExt:avi,mp4,wmv,mov,flv|fileSize:52428800',
        'attachment'              => 'fileExt:zip,rar,7z,pdf,txt,doc,mp3,mp4,jpg,png,avif,wav,m4a|fileSize:52428800',
    ];

    protected $message = [
        'image.fileExt'      => '该文件类型不允许上传',
        'image.fileSize'     => '该文件类型最大5M',

        'video.fileExt'      => '该视频类型不允许上传',
        'video.fileSize'     => '视频文件最大50M',

        'attachment.fileExt'      => '该附件类型不允许上传',
        'attachment.fileSize'     => '附件文件最大50M',
    ];


}