<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use think\model\concern\SoftDelete;

class ArticleComment extends BaseModel
{
    // use SoftDelete;
    // protected $deleteTime = 'delete_time';

    public function getCommentAttr($value)
    {
        if(str_starts_with($value,'@image')){
            $path =explode('=',$value);
            return \app\common\service\FileService::getFileUrl($path[1]);
        };

        return $value;
    }

    public function article()
    {
        return $this->hasOne(Article::class,'id','aid');
    }

    public function user()
    {
        return $this->hasOne(User::class,'id','user_id')->field('id,sn,nickname,avatar,level')->with('userLevel');
    }

    public function replyUser()
    {
        return $this->hasOne(User::class,'id','reply_user_id')->field('id,sn,nickname,avatar,level');
    }


    /**
     * @notes 获取点赞数
     */
    public function getCollectNumAttr($value ,$data)
    {
        return UserCollect::where([ 'aid' => $data['aid'] ,'type' => 3 , 'comments_id' => $data['id']])->count();
    }

    /**
     * 自营商品
     */
    public function goods()
    {
        return $this->hasOne(Goods::class,'id','goods_id');
    }

}