<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */



namespace app\api\validate;

use app\common\validate\BaseValidate;

/**
 * PC商城验证器
 */
class PcValidate extends BaseValidate
{
    protected $rule = [
        'goods_id'     => 'require',
        'nickname'     => 'require',
        'sex'     => 'require|in:1,2',
        'order_goods_id' => 'require'
    ];

    protected $message = [
        'goods_id.require'      => '商品ID不能为空',
        'nickname.require' => '请输入昵称',
        'sex.require' => '请选择性别',
        'sex.in' => '性别值错误',
        'order_goods_id.require' => '参数缺失',
    ];



    public function sceneGoodsDetail()
    {
        return $this->only(['goods_id']);
    }

    public function sceneGoodsCommentCategory()
    {
        return $this->only(['goods_id']);
    }

    public function sceneGoodsCommentLists()
    {
        return $this->only(['goods_id']);
    }

    public function sceneSetUserInfo()
    {
        return $this->only(['nickname', 'sex']);
    }

    public function sceneAfterSaleApplyPage()
    {
        return $this->only(['order_goods_id']);
    }
}