<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\lists;

use app\common\{enum\UserTerminalEnum, model\Goods, enum\GoodsEnum, model\SearchRecord, service\ConfigService};
use think\facade\Db;

/**
 * 商品列表接口
 * Class GoodsLists
 * @package app\api\lists
 */
class GoodsLists extends BaseShopDataLists
{
    public function setSearch(): array
    {
        return array_diff(array_keys($this->params), ['page_no', 'page_size']);
    }


    /**
     * @note 首页商品列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $list = Goods::withSearch($this->setSearch(), $this->params)
            ->field('*,virtual_sales_num+sales_num as sales_num,min_price as sell_price,min_lineation_price as lineation_price')
            ->where(['status'=>GoodsEnum::STATUS_SELL])
            ->limit($this->limitOffset, $this->limitLength)
            ->order('sort desc,id desc')
            ->select();
        $showPrice = ConfigService::get('goods_set', 'show_price', 1);
        if(0 == $showPrice){
            foreach ($list as $goods){
                $goods->lineation_price = 0;
            }
        }

        $name = $this->params['name'] ?? '';
        // if ($name && $this->userId && $this->userInfo['terminal'] != UserTerminalEnum::PC) {//记录关键词
        //     $this->recordKeyWord(trim($name), $this->userId);
        // }

        return $list->toArray();

    }

    /**
     * @notes 商品统计
     * @return int
     */
    public function count(): int
    {
        return Goods::withSearch($this->setSearch(), $this->params)
            ->where(['status'=>GoodsEnum::STATUS_SELL])
            ->count();

    }

    /**
     * @notes 记录商品搜索
     * @param $name
     * @param $userId
     * @return bool
     */
    public function recordKeyWord($name,$userId):bool
    {
        $searchRecord = SearchRecord::where(['user_id'=>$userId,'keyword'=>$name])->findOrEmpty();

        if($searchRecord->isEmpty()){
            $searchRecord->user_id = $userId;
            $searchRecord->keyword = $name;
            $searchRecord->save();
            return true;
        }
        $searchRecord->count = Db::raw('count+1');
        $searchRecord->save();
        return true;
    }
}