<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;

use app\api\lists\ArticleLists;
use app\common\logic\ChatLogic;
use app\api\logic\DecorateThemeLogic;
use app\api\logic\IndexLogic;

/**
 * 首页
 * Class IndexController
 * @package app\api\controller
 */
class Index extends BaseShopController
{
    public array $notNeedLogin = ['home' , 'search_user' , 'weather', 'getLoginConfig'];

    public function home()
    {
        IndexLogic::visit([
            'terminal' => $this->terminal
        ]);

        $params = $this->request->param();

        // 首页弹窗内容
        $alert = \app\common\service\ConfigService::get('index', 'alert','');

        // 首页公告
        $notice = \app\common\service\ConfigService::get('index', 'notice','');

        $nav_index_tab = \app\common\model\Nav::where([
            'status'=>1,
            'location'=>'index_tab',
            'show_type'=>'button'
        ])
        ->order('sort','desc')
        ->select()->toArray();

        $nav_index_image = \app\common\model\Nav::where([
            'status'=>1,
            'location'=>'index_image',
            'show_type'=>'image'
        ])
        ->order('sort','desc')
        ->select()->toArray();

        $image_button = \app\common\model\Nav::where('status',1)->select()->toArray();

        // 轮播他
        $banner = \app\common\model\Banner::where([
            ['status','=',1],
            ['location','=',$params['location'] ?? 'index'],
        ])->select();

        $data = [
            'alert'=>$alert,
            'notice'=>$notice,
            'banner'=>$banner,
            'nav_tab'=>$nav_index_tab,
            'nav_image'=>$nav_index_image,
        ];

        return show(config('status.success'),'',$data);
        
    }

    public function getLoginConfig()
    {
        return show(1,'',[
            'bg_type' => \app\common\service\ConfigService::get('login', 'bg_type','image'),
            'bg_src' => \app\common\service\ConfigService::get('login', 'bg_src',''),
            'bg_scroll' => \app\common\service\ConfigService::get('login', 'bg_scroll','1'),
        ]);
    }

    public function weather(){

        $params = $this->request->get();
        $result = IndexLogic::weather($params);
        if ($result) {
            return $this->data($result);
        }
        return $this->fail(IndexLogic::getError(), [], 0, 0);
    }

    /**
     * @notes 首页访客记录
     */
    public function visit()
    {
        $result = IndexLogic::visit([
            'terminal' => $this->terminal
        ]);
        if ($result) {
            return $this->success('');
        }
        return $this->fail(IndexLogic::getError(), [], 0, 0);
    }

    public function user_search(){

        $params = $this->request->get();
        $result = IndexLogic::search_user($params);
        
        return $this->data($result);
        
    }



}
