<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;

use app\api\lists\ArticleLists;
use app\common\logic\ChatLogic;
use app\api\logic\DecorateThemeLogic;
use app\api\logic\IndexLogic;

/**
 * 盲盒交友
 * Class IndexController
 * @package app\api\controller
 */
class BlindBoxe extends BaseShopController
{
    public array $notNeedLogin = ['index'];
   
    /**
     * 创建盲盒
     */
    public function create()
    {
        $params = $this->request->post();

        $data = [
            "user_id"=>$this->userId,
            'title'=>$params['title'],
            'desc'=>$params['desc'],
            'content'=>$params['content'],
            'min_age'=>$params['min_age'],
            'max_age'=>$params['max_age'],
            'location_scope'=>$params['location_scope']??'',
            'expire_time'=>$params['expire_time'],
            'region_id'=>$params['region_id'],
            'status'=>1,
        ];

        $user = \app\common\model\User::find($this->userId);
        if($user->sex == 0){
            return show(config('status.success'),'请先设置性别');
        }

        $res = \app\common\model\BlindBoxeRecord::create($data);
        if(!$res){
            return \show(config('status.error'),'添加失败');
        }

        return \show(config('status'),'添加成功');
        
    }


    /**
     * 创建订单，抽取一张纸条
     */
    public function createOrder()
    {
        $params = $this->request->post();

        $where = [
            ['u.sex','=',$params['sex']]
        ];

        $count = \app\common\model\BlindBoxe::alias('b')
        ->where([
            'status'=>1,
        ])
        ->leftJoin('user u','b.user_id=u.id')
        ->where($where)
        ->count();


        if($count == 0){
            return \show(config('status.success'),'被抽完啦，晚点再来哦！');
        }
        // 抽取一张纸条的价格
        $price = \app\common\service\ConfigService::get("blind_boxe",'price',0);

        $data = [
            'user_id'=>$this->userId,
            'region_id'=>isset($params['region_id'])??0,
            'order_amount'=>$price,
            'sn'=>time().$this->userId,
            'sex'=>$params['sex']==1?1:2,
        ];

        $order = \app\common\model\BlindBoxeOrder::create($data);
        if(!$order){
            return show(config('status.error'),'error');
        }
        
        return show(config('status.success'),'ok',[
            'order_id' => $order->id,
            'from' => 'blind_boxe'
        ]);

        
    }

    /**
     * 盲盒首页信息
     */
    public function index()
    {

        $params = $this->request->post();

        $where = [];

        // 最小年龄（出生日期）
        if(isset($params['min_birth'])){
            // 计算年龄应该的时间戳
            $where[]=[
                'u.birth','<',$params['min_birth']
            ];
        }
        // 最大年龄（出生日期）
        if(isset($params['max_birth'])){
            $where[]=[
                'u.birth','<',$params['max_birth']
            ];
        }
        
        // 获取男生盲盒子数量
        $boy_count = \app\common\model\BlindBoxe::alias('b')
        ->where([
            'status'=>1,
        ])
        ->leftJoin('user u','b.user_id=u.id')
        ->where('u.sex','男')
        ->select()
        ->count();

        $girl_count = \app\common\model\BlindBoxe::alias('b')
        ->where([
            'status'=>1,
        ])
        ->leftJoin('user u','b.user_id=u.id')
        ->where('u.sex','女')
        ->where($where)
        ->select()
        ->count();

        $data = [
            ['boy_count'=>$boy_count],
            ['girl_count'=>$girl_count]
        ];

        return show(config('status.success'),'',$data);
    }

    /**
     * 订单列表
     */
    public function orderList()
    {

        $list = \app\common\model\BlindBoxeOrder::where([
            "user_id"=>$this->userId
        ])
        ->order('id desc')
        ->select()
        ->toArray();


        return \show(config('status.success'),'',$list);

    }

    /**
     * 查询我匹配的列表
     */
    public function myBlindBoxe()
    {

        $params = $this->request->get();
        $where = [];
        // 查询我投放的纸条
        $list = \app\common\model\BlindBoxe::with('order')
        ->where($where)
        ->select();

        return show(config('status.success'),'',$list);
    }
    

}
