<?php

namespace app\api\controller;

use app\common\model\Article;
use app\common\model\ArticleDraft;

class ArticleMy extends BaseShopController
{
    public function list()
    {
        $params = $this->request->param();

        $query = Article::alias('a')->field('a.*');

        if (isset($params['title'])) {
            $query = $query->where('a.title', 'like', '%' . $params['title'] . '%');
        }

        if (isset($params['is_like'])) {
            $query = $query->join('user_collect uc', 'uc.aid = a.id AND uc.type = 2 AND uc.user_id = "' . $this->userId . '"')->group('uc.aid');
        } else {
            $query = $query->where('a.user_id', $this->userId);
        }

        if (isset($params['is_collect'])) {
            $query = $query->join('user_collect uc', 'uc.aid = a.id AND uc.type = 1 AND uc.user_id = "' . $this->userId . '"')->group('uc.aid');
        } else {
            $query = $query->where('a.user_id', $this->userId);
        }

        if (isset($params['is_private'])) {
            $query = $query->where('a.user_id', $this->userId);
            $query = $query->where('a.is_open', 2);
        } else {
            $query = $query->where('a.user_id', $this->userId);
            $query = $query->where('a.is_open', 1);
        }

        if (isset($params['is_history'])) {
            $query = $query->join('article_visit av', 'av.aid = a.id AND av.visit > 0 AND av.user_id = "' . $this->userId . '"')->group('av.aid');
        }

        if (empty($params)) {
            $query = $query->where('a.user_id', $this->userId);
        }

        $result = $query->paginate(16);

        return show(1, '列表', $result);
    }

    public function listDraft()
    {
        $params = $this->request->param();

        $query = ArticleDraft::alias('ad');

        $query = $query->where('ad.user_id', $this->userId);

        if (isset($params['title'])) {
            $query = $query->where('ad.title', 'like', '%' . $params['title'] . '%');
        }

        $result = $query->paginate(16);

        return show(1, '列表', $result);
    }
}