<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\validate\user;
use app\common\{
    validate\BaseValidate,
    model\UserLevel
};

/**
 * 会员等级验证器
 * Class UserLevelValidate
 * @package app\adminapi\validate\user
 */
class UserLevelValidate extends BaseValidate
{
    protected $regex = ['condition'=>'/^[0-9]+(.[0-9]{1,2})?$/'];
    protected $rule = [
        'id'                => 'require',
        'name'              => 'require|max:32|unique:'.UserLevel::class.',name',
        'rank'              => 'require|unique:'.UserLevel::class.',rank|gt:0',
        'level_discount'    => 'require|in:0,1',
        'discount'          => 'requireIf:level_discount,1|between:0,10',
        'condition'         => 'requireCallback:checkRequire|array|checkCondition'
    ];

    protected $message = [
        'id.require'                => '请选择等级',
        'name.require'              => '请输入等级名称',
        'name.max'                  => '等级名称最多为32个字符',
        'name.unique'               => '等级名称已存在',
        'rank.require'              => '请输入级别',
        'rank.unique'               => '级别重复，请重新输入',
        'rank.gt'                   => '级别必须大于零',
        'level_discount.require'    => '请选择等级折扣',
        'level_discount.in'         => '等级折扣类型错误',
        'discount.requireIf'        => '请填写等级折扣',
        'discount.between'          => '等级折扣值在0~10之间',
        'condition.requireCallback' => '请选择会员条件',
        'condition.array'           => '会员条件数据格式错误',
    ];

    //添加验证
    public function sceneAdd()
    {
        return $this->remove(['id'=>'require']);
    }
    //删除验证
    public function sceneDel(){
        return $this->only(['id'])
                ->append('id','checkLevel');
    }

    public function checkRequire($value,$data){
        if(1 != $data['rank'] && empty($data['condition'])){
            return true;
        }
    }


    public function checkLevel($value,$rule,$data){
        $userLevel = UserLevel::find($value);
        if(1 == $userLevel->rank) {
            return '系统默认等级不允许删除';
        }
        return true;
    }

    
    public function checkCondition($value,$rule,$data)
    {
        if(1 == $data['rank']){
            return true;
        }

        //
        $conditionType = $value['condition_type'] ?? '';
        $singleMoney = $value['single_money'] ?? '';
        $isSingleMoney = $value['is_single_money'] ?? '';
        $totalMoney = $value['total_money'] ??  '';
        $isTotalMoney = $value['is_total_money'] ??  '';
        $totalNum = $value['total_num'] ?? '';
        $isTotalNum = $value['is_total_num'] ?? '';

        //数据缺少情况
        if('' === $conditionType){
            return '请选择升级条件类型';
        }
        if('' === $isSingleMoney || '' === $isTotalMoney || '' === $isTotalNum){
            return '等级条件数据错误';
        }
        //没选择条件情况下
        // if('0' === $isSingleMoney && '0' === $isTotalMoney && '0' === $isTotalNum){
        //     return '至少选择一个条件';
        // }


        if($isSingleMoney){
            if(empty($singleMoney)){
                return '请输入单笔消费金额条件';
            }
            if($singleMoney <= 0){
                return '单笔消费金额条件必须大于零';
            }
        }

        if($isTotalMoney){
            if(empty($totalMoney)) {
                return '请输入累计消费金额条件';
            }
            if($totalMoney <= 0){
                return '单笔消费金额条件必须大于零';
            }
        }
        if($isTotalNum ){
            if(empty($totalNum)) {
                return '请输入累计消费次数条件';
            }
            if($totalNum <= 0){
                return '累计消费次数条件必须大于零';
            }
        }

        return true;
    }
}