<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\validate\ad;

use app\common\model\Ad;
use app\common\validate\BaseValidate;

/**
 * 广告位
 */
class PositionValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require',
        'name' => 'require|unique:ad_position,name^del^client|max:60',
    ];

    protected $message = [
        'id.require' => 'id不能为空',
        'delData.require' => 'id不能为空',
        'name.require' => '请输入广告标题',
        'name.unique' => '广告标题已存在',
        'name.max' => '广告标题过长',
        'type.require' => '请选择广告类型'

    ];


    protected function sceneAdd()
    {
        $this->remove(['id']);
    }

    protected function sceneEdit()
    {
    }

    protected function sceneDel()
    {

        $this->only(['delData'])
            ->append('delData','require')
            ->append('delData','checkQuote');
    }

    protected function checkQuote($value, $rule, $data){

        if (is_array($value)){
            $pid = Ad::where(['pid'=>$value,'client'=>$data['client']])
                ->select();
            if (!empty($pid)){
                return "请先删除引用该广告位的广告";
            }
        }else {
            $pid = Ad::where(['pid'=>$value,'client'=>$data['client']])
                ->find();
            if (!empty($pid)){
                return "请先删除引用该广告位的广告";
            }
        }

        return true;
    }
}
