<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\validate;
use app\common\model\Admin;
use app\common\validate\BaseValidate;
use think\facade\Config;

class ResetPasswordValidate extends BaseValidate
{
    protected $rule = [
        'password'              => 'require|min:6|confirm',
        'origin_password'       => 'require|checkPassword',
    ];

    protected $message = [
        'origin_password.require'       => '请输入当前密码',
        'password.require'              => '请输入新密码',
        'password.min'                  => '新密码至少六位数',
        'password.confirm'              => '两次密码输入不一致',
        'password_confirm.require'      => '请输入确认密码',
    ];


    public function checkPassword($value,$rule,$data){
        if($value == $data['password']){
            return '新密码和当前密码一样，请重新输入密码';
        }
        $passwordSalt = Config::get('project.unique_identification');
        $adminInfo = Admin::where('id', '=', $data['admin_id'])
            ->field(['password,disable'])
            ->find();

        if ($adminInfo['password'] !== create_password($value, $passwordSalt)) {
            return '密码错误';
        }
        return true;
    }



}