<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\validate;

use app\common\validate\BaseValidate;

use app\common\model\Admin;
use think\facade\Config;

class MyValidate extends BaseValidate
{
    protected $rule = [
        'old_password' => 'require|checkOld',
        'new_password' => 'require|length:6,32',
        'new_password_confirm' => 'require|confirm:new_password',
    ];

    protected $message = [
        'old_password.require' => '原密码不能为空',
        'new_password.require' => '新密码不能为空',
        'new_password.length' => '新密码长度需在6-32个字符之间',
        'new_password_confirm.require' => '确认新密码不能为空',
        'new_password_confirm.confirm' => '两次输入的新密码不一致',
    ];

    /**
     * @notes 校验原密码
     * @param $value
     * @param $rule
     * @param $data
     * @return bool|string
     */
    public function checkOld($value, $rule, $data)
    {
        $admin = Admin::findOrEmpty($data['id']);
        $passwordSalt = Config::get('project.unique_identification');
        $password = create_password($value, $passwordSalt);
        if ($admin->password != $password) {
            return '原密码错误';
        }
        return true;
    }
}