<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\validate;

use app\common\model\Article;
use app\common\model\ArticleCategory;
use app\common\validate\BaseValidate;

class ArticleValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require',
        'title' => 'require',
        'cid' => 'require|checkCid',
        'func' => 'require|in:status,is_recomment,is_top'
        
    ];

    protected $message = [
        'title.require' => '标题不能为空',
        'cid.require' => '请选择分类',
        'func.in' => '非法参数',
    ];

    /**
     * @notes 添加文章/帮助场景
     * @return ArticleValidate
     */
    public function sceneAdd()
    {
        return $this->remove('id', 'require');
    }

    /**
     * @notes 获取文章/帮助详情场景
     * @return ArticleValidate
     */
    public function sceneDetail()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 删除文章/帮助场景
     * @return ArticleValidate
     */
    public function sceneDelete()
    {
        return $this->only(['id']);
    }


    public function sceneStatus()
    {
        return $this->only(['id' , 'func']);
    }


    /**
     * @notes 校验文章/帮助分类
     * @param $value
     * @return bool|string
     */
    public function checkCid($value)
    {
        $articleCategory = ArticleCategory::findOrEmpty($value);
        if($articleCategory->isEmpty()) {
            return '分类不存在';
        }
        return true;
    }
}