<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\collect\info;

use app\adminapi\controller\BaseAdminController;

/**
 * 西瓜分类信息-分类信息
 * Class UserController
 * @package app\adminapi\controller\user
 */
class CommentCollect extends BaseAdminController
{
    // DZ-西瓜/分类行业数据采集
    public function insertDZXG()
    {
        $list = $this->request->post('list');
        $page = $this->request->post('page');

        $saveData=[];

        $err=[];

        foreach($list as $v){

            // 判断评论是否存在
            $article=\app\common\model\Article::where('dz_id',$v['pubid'])->find();
            if(!$article){
                $err[]=[
                    "msg"=>"请先采集用户",
                    "dz_uid"=>$v['pubid'],
                ];
                continue;
            }

            // 判断用户是否存在
            $user=\app\common\model\User::where('dz_uid',$v['authorid'])->find();
            if(!$user){
                $err[]=[
                    "msg"=>"请先采集用户",
                    "dz_uid"=>$v['uid'],
                ];
                continue;
            }

            // 将分类保存到圈子里
            $saveData[]=[
                "dz_id"=>$v['cid'],
                "user_id"=>$user->id,
                "aid"=>$article->id,//文章id
                "pid"=>0,
                "comment"=>$v['comment'],//评论文本
                "content"=>$v['comment'],//评论内容带格式
                "create_time"=>$v['crts'],
                "star_num"=>$v['star'],//点赞数
                "ip"=>$v['ip'],
            ];

        }


        try{

            $res = \think\facade\Db::name('article_comment')
            ->extra('IGNORE')
            ->insertAll($saveData);

            // 记录当前页数 用于下次断点采集
            \app\common\service\ConfigService::set('InfoCommentCollect','dz_page',$page);

            return \show(1,'导入成功',$err);
        }catch(\Exception $e){
            return \show(0,'导入失败'.$e->getMessage());
        }
    
    }

    // 查询上一次采集到第几页
    public function dzPageRecord()
    {
        $page=\app\common\service\ConfigService::get('InfoCommentCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

    public function dzPageRecordDel()
    {
        $page=\app\common\service\ConfigService::set('InfoCommentCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

}