<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\collect;

use app\adminapi\controller\BaseAdminController;


/**
 * 文章数据采集
 * Class UserController
 * @package app\adminapi\controller\user
 */
class ArticleCollect extends BaseAdminController
{

    // DZ用户数据采集
    public function insertArticleDZ()
    {
        $list = $this->request->post('list');
        $page = $this->request->post('page');
        $dz_circle_id = $this->request->post('dz_circle_id');

        // 先查询绑定关系
        $dz_circle_data=\app\common\model\DzCircleBind::where('dz_circle_id',$dz_circle_id)
        ->find();

        if(!$dz_circle_data){
            return show(0,'请先绑定圈子关系');
        }

        $err=[];
        try{

            foreach($list as $v){
                // 通过dz_uid查询本地用户id
                $sns_user=\app\common\model\User::where('dz_uid',$v['authorid'])->find();
                if(!$sns_user){
                    $err[]=[
                        "dz_id"=>intval($v['tid']),
                        "msg"=>"本地未找到对应用户，此文章不采集",
                    ];
                    continue;
                }

                $articleData=[
                    "dz_id"=>intval($v['tid']),
                    "user_id"=>$sns_user->id,
                    "circle_id"=>$dz_circle_data->sns_circle_id,//采集到圈子id
                    "title"=>$v['subject'],//帖子名称
                    "content"=>$v['message'],//文章内容
                    "create_time"=>$v['dateline'],//发布时间
                    'image'=>'',
                    'cloud_url'=>'',
                    'cloud_password'=>'',
                ];
                // dd($articleData);
                $articleRes = \app\common\model\Article::create($articleData);

                // dd($v['comment']);
                $commentSaveData=[];
                foreach($v['comment'] as $v2){
                    // dd($v2['pid']);
                    // 评论数据
                    $commentSaveData[]=[
                        'dz_id'=>intval($v2['pid']),
                        'pid'=>0,
                        "user_id"=>$sns_user->id,//用户id
                        "aid"=>$articleRes->id,//文章id
                        "comment"=>$v2['message'],
                        "content"=>$v2['message'],
                        'create_time'=>$v2['dateline'],
                        'status'=>1,
                    ];
                }
                $res=\app\common\model\ArticleComment::insertAll($commentSaveData);
                
            }


            // 记录当前页数 用于下次断点采集
            \app\common\service\ConfigService::set('article_collect','dz_page_'.$dz_circle_id,$page);

            return \show(1,'导入成功',$err);
        }catch(\Exception $e){
            return \show(0,'导入失败'.$e->getMessage());
        }

        
    }

    // 删除所有dz采集的用户数据
    public function delAllDZArticle()
    {
        \app\common\model\Article::whereNotNull("dz_id")->select()->delete();
        \app\common\model\ArticleComment::whereNotNull("dz_id")->select()->delete();
        return \show(1,'删除成功');
    }

    // 查询上一次采集到第几页
    public function dzPageRecord($dz_circle_id)
    {
        $page=\app\common\service\ConfigService::get('article_collect','dz_page_'.$dz_circle_id,0);
        return \show(1,['page'=>$page]);
    }

    // 清楚断点采集记录
    public function dzPageRecordDel($dz_circle_id)
    {
        $page=\app\common\service\ConfigService::set('article_collect','dz_page_'.$dz_circle_id,0);
        return \show(1,['page'=>$page]);
    }

}