<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

use app\adminapi\logic\auth\AuthLogic;
use app\adminapi\logic\ConfigLogic;

/**
 * 配置控制器
 * Class ConfigController
 * @package app\adminapi\controller
 */
class Config extends BaseAdminController
{
    public array $notNeedLogin = ['getConfig'];

    /**
     * @notes 获取配置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $data = ConfigLogic::getConfig();
        return $this->data($data);
    }

    /**
     * @notes 获取菜单
     * @return \think\response\Json
     */
    public function getMenu()
    {
        $auth = AuthLogic::getMenu('menu');
        return $this->data($auth);
    }

    /**
     * @notes 获取权限
     * @return \think\response\Json
     */
    public function getAuth()
    {
        $data = ConfigLogic::getAuth($this->adminInfo);
        return $this->data($data);
    }

    /**
     * @notes 获取营销模块接口
     * @return \think\response\Jon
     */
    public function getMarketingModule()
    {
        $data = ConfigLogic::getMarketingModule();
        return $this->data($data);
    }

    /**
     * @notes 获取应用中心模块接口
     * @return \think\response\Json
     */
    public function getAppModule()
    {
        $data = ConfigLogic::getAppModule();
        return $this->data($data);
    }

    
}
