<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\service\RegionService;
use think\model\concern\SoftDelete;

/**
 * 用户地址模型
 * Class UserLevel
 * @package app\common\model
 */
class UserAddress extends BaseModel
{
    use SoftDelete;
    protected $deleteTime = 'delete_time';

    protected $append = ['province', 'city', 'district'];


    public function getProvinceAttr($value, $data)
    {
        return RegionService::getAddress($data['province_id']);
    }


    public function getCityAttr($value, $data)
    {
        return RegionService::getAddress($data['city_id']);
    }

    public function getDistrictAttr($value, $data)
    {
        return RegionService::getAddress($data['district_id']);
    }

    /**
     * @notes 获取默认收货地址
     * @param $user_id
     * @return array
     * @throws @\think\db\exception\DataNotFoundException
     * @throws @\think\db\exception\DbException
     * @throws @\think\db\exception\ModelNotFoundException
     */
    public static function getDefaultAddress($user_id)
    {
        $model = new self;
        $result = $model->where(['user_id' => $user_id])
            ->where('is_default', 1)
            ->order('is_default desc')
            ->find();

        if (!$result) {
            return [];
        }

        return $result;
    }

    /**
     * @notes 根据ID获取地址
     * @param $user_id
     * @param $id
     * @return array
     * @throws @\think\db\exception\DataNotFoundException
     * @throws @\think\db\exception\DbException
     * @throws @\think\db\exception\ModelNotFoundException
     */
    public static function getAddressById($user_id, $id)
    {
        $model = new self;
        $result = $model->where(['user_id'=>$user_id])
            ->where('id', '=', intval($id))
            ->find();

        if (!$result) {
            return [];
        }

        return $result;
    }

    /**
     * @notes 获取一条收货地址
     * @param $user_id
     * @param $id
     * @return array
     */
    public static function getOneAddress($user_id, $id=0)
    {
        if ($id > 0) {
            return self::getAddressById($user_id, $id);
        }

        return self::getDefaultAddress($user_id);
    }
}