<?php
declare (strict_types = 1);

namespace app\common\model;

use think\Model;

use think\model\Pivot;

/**
 * @mixin \think\Model
 */
class MerchantGoodsPackage extends Model
{
     public function goods()
     {
         // 三个参数分别是：被关联模型名、中间表名、当前模型外键、被关联模型外键
        //  return $this->belongsToMany(MerchantGoods::class, 'merchant_goods_package_goods', 'package_id', 'goods_id');

         // 参数说明：
        // 1. 被关联模型类名
        // 2. 中间表名称
        // 3. 中间表中与当前模型关联的外键（用户ID）
        // 4. 中间表中与被关联模型关联的外键（角色ID）
        return $this->belongsToMany(
            MerchantGoods::class,       // 被关联模型
            MerchantGoodsPackageGoodsPivot::class,      // 中间表
            'goods_id',          // 中间表中关联被关联模型的外键
            'package_id',         // 中间表中关联当前模型的外键（注意顺序）
        );
     }
}
