<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;


use app\adminapi\logic\goods\GoodsCategoryLogic;
use app\common\enum\YesNoEnum;
use app\common\service\FileService;
use think\model\concern\SoftDelete;

class GoodsCategory extends BaseModel
{

    use SoftDelete;
    protected $deleteTime = 'delete_time';

    /**
     * @notes 商品分类名称搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchNameAttr($query, $value, $data)
    {
        $query->where('name','like', '%' .$value . '%');
    }

    /**
     * @notes 商品分类等级搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchLevelAttr($query, $value, $data)
    {
        $query->where('level','<=',$value);
    }

    /**
     * @notes 获取完整分类名称
     * @param $value
     * @return string
     */
    public function getCompleteNameAttr($value, $data)
    {
        return GoodsCategoryLogic::getCompleteName($data['id']);
    }

    /**
     * @notes 状态获取器
     * @param $value
     * @param $data
     * @return string
     */
    public function getIsShowDescAttr($value, $data)
    {
        return YesNoEnum::getIsShowDesc($data['is_show']);
    }
}