<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\model\User;
use app\common\model\UserFollow;

/**
 * 排行榜
 * Class FansLists
 * @package app\api\lists
 */
class RankingLists extends BaseShopDataLists
{

    /**
     * @notes 粉丝列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {

        
        if( isset( $this->params['type']) &&  $this->params['type'] == 0){

            $list = User::join('user_fans', 'user.id = user_fans.user_id')
            ->field('user.id,avatar,nickname, COUNT(user_fans.id) AS fans_count')
            ->group('user.id')
            ->order('fans_count', 'desc')
            ->limit(50)
            ->select();

        } else {
            $model =  new User;
            $where = [];
            $order = 'user_money desc';
            $field = 'id,avatar,nickname,user_money';

        }
        $lists = $model::order($order)
            ->limit(50)
            ->field($field)
            ->select()
            ->toArray();

        // 取指定页数据
        return $lists;
    }

    /**
     * @notes 粉丝数量
     * @return int
     */
    public function count(): int
    {

        if( isset( $this->params['type']) &&  $this->params['type'] == 0){
            
        } else {
            $model =  new User;
            $where = [];
            $order = [];
        }

        $count = $model::order($order)->count();

        return $count;
    }
}