<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\http\middleware;
use app\common\model\User;
use app\common\service\JsonService;

class InspectAccountMiddleware{


    /**
     * @notes 账号是否合法
     * @param $request
     * @param \Closure $next
     * @return mixed|\think\response\Json
     * @author lgp
     * @date
     */
    public function handle($request, \Closure $next)
    {
        $userId = $request->userId;
        if($userId > 0){
            $disable = User::where(['id'=>$userId])->value('disable');
            if($disable){
                return JsonService::fail('您的账号被冻结，请联系客服。', [], -1, 1);

            }
        }
        return $next($request);
    }

}