<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;
use think\facade\Db;

/**
 * 表情
 */
class Emo extends BaseShopController
{

    public array $notNeedLogin = ['list'];
    
    public function list()
    {

        $list = \app\common\model\EmoCategory::with(['image'])
        ->order('sort','desc')
        ->select()
        ->toArray();

        $list[]=\app\common\model\EmoImage::where('user_id',$this->userId)->order('sort','desc');

        return show(config('status.success'),'',$list);
        
    }

    /**
     * 用户上传自定义表情包
     */
    public function add()
    {
        $params = $this->request->post();
        $data = [
            'image'=>$params['image'],
            'user_id'=>$this->userId,
            'category_id'=>0,
        ];
        \app\common\model\EmoImage::create($data);

        return show(config('status.success'),'添加成功');
    }

     /**
      * 修改自定义表情包排序
      */
    public function updateSort()
    {
        $params = $this->request->post();

        \app\common\model\EmoImage::update(['sort'=>$params['sort']],['id'=>$params['id'],'user_id'=>$this->userId]);

        return show(config('status.success'),'','修改成功');
    }
}
