<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;


use app\common\controller\BaseCommonShopController;

class BaseShopController extends BaseCommonShopController
{
    protected int $userId = 0;
    protected array $userInfo = [];

    protected string $terminal;
    
    public function initialize()
    {

        // 获取控制器名（含命名空间，完整类名）
        $controllerClass = $this->request->controller(true);
        $action = $this->request->action();
        $url = $controllerClass.'/'.$action;
        $not_terminal=[
            'poster/code',
            'upload/image',
            'upload/video',
            'login/wechatCallback',
            'login/getWechatAuthUrl',
            'login/wechatQrLoginCallback',
            'goods/categoryList'
        ];
        if(!in_array($url,$not_terminal)){
            $headers = $this->request->header();
            if(!isset($headers['terminal'])){
                dd("请求头请携带terminal：1-微信小程序；2-微信公众号；3-手机H5；4-电脑PC；5-苹果APP；6-安卓APP',");
            }
            $this->terminal = $headers["terminal"];
        }
        

        if (isset($this->request->userInfo) && $this->request->userInfo) {
            $now = time();

            \app\common\model\User::where('id', $this->request->userInfo['user_id'])
                ->update([
                    'last_online_time' => $now
                ]);

            $this->userInfo = $this->request->userInfo;
            $this->userId = $this->request->userInfo['user_id'];
        }

    }

}