<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\validate\settings\shop;

use app\common\validate\BaseValidate;

/**
 * 店铺设置验证器
 * Class ShopSettingsValidate
 * @package app\adminapi\validate\settings\shop
 */
class ShopSettingsValidate extends BaseValidate
{
    protected $rule = [
        'name' => 'require',
        'logo' => 'require',
        'admin_login_image' => 'require',
        'login_restrictions' => 'require|in:0,1',
        'password_error_times' => 'requireIf:login_restrictions,1|integer|gt:0',
        'limit_login_time' => 'requireIf:login_restrictions,1|integer|gt:0',
        'status' => 'require|in:0,1',
        'share_page' => 'require|in:1',
        'mall_contact' => 'require',
        'mall_contact_mobile' => 'require|mobile',
        'return_contact' => 'require',
        'return_contact_mobile' => 'require|mobile',
        'return_province' => 'require',
        'return_city' => 'require',
        'return_district' => 'require',
        'return_address' => 'require',
    ];

    protected $message = [
        'name.require' => '请输入系统名称',
        'logo.require' => '请上传logo',
        'admin_login_image.require' => '请上传管理后台登录页图片',
        'login_restrictions.require' => '请选择管理后台登录限制',
        'login_restrictions.in' => '管理后台登录限制状态值有误',
        'password_error_times.requireIf' => '请输入密码错误次数',
        'password_error_times.integer' => '密码错误次数须为整型',
        'password_error_times.gt' => '密码错误次数须大于0',
        'limit_login_time.requireIf' => '请输入限制登录分钟数',
        'limit_login_time.integer' => '限制登录分钟数须为整型',
        'limit_login_time.gt' => '限制登录分钟数须大于0',
        'status.require' => '请选择平台状态',
        'status.in' => '平台状态值有误',
        'share_page.require' => '请选择分享页面',
        'share_page.in' => '分享页面值有误',
        'share_image.require' => '请上传分享图片',
        'mall_contact.require' => '请输入联系人姓名',
        'mall_contact_mobile.require' => '请输入联系人手机号',
        'mall_contact_mobile.mobile' => '联系人手机号格式错误',
        'return_contact.require' => '请输入退货联系人',
        'return_contact_mobile.require' => '请输入退货联系人手机号',
        'return_contact_mobile.mobile' => '退货联系人手机号格式错误',
        'return_province.require' => '请选择退货省份',
        'return_city.require' => '请选择退货城市',
        'return_district.require' => '请选择退货地区',
        'return_address.require' => '请输入退货详细地址',
    ];

    /**
     * @notes 设置店铺信息场景
     * @return ShopSettingsValidate
     */
    public function sceneSetShopInfo()
    {
        return $this->only(['name', 'logo', 'admin_name', 'admin_logo', 'admin_login_image', 'login_restrictions', 'password_error_times', 'limit_login_time', 'status', 'mall_contact', 'mall_contact_mobile', 'return_contact', 'return_contact_mobile', 'return_province', 'return_city', 'return_district', 'return_address']);
    }

    /**
     * @notes 分享设置场景
     * @return ShopSettingsValidate
     */
    public function sceneSetShareSetting()
    {
        return $this->only(['share_page', 'share_image']);
    }
}