<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\logic\user;
use app\common\enum\PayEnum;
use app\common\model\
{
    User,
    Order,
    UserLevel
};


/**
 * 会员等级逻辑层
 * Class UserLevelLogic
 * @package app\adminapi\logic\user
 */
class UserLevelLogic
{

    /**
     * @notes 添加会员等级
     * @param array $params
     * @return bool
     */
    public function add(array $params)
    {

        $userLevel = new UserLevel();

        //等级条件
        // $condition = $this->disposeCondition($params['condition']);

        $userLevel->name             = $params['name'];
        $userLevel->rank             = $params['rank'];
        $userLevel->image            = $params['image'];
        // $userLevel->background_image = $params['background_image'];
        $userLevel->remark           = $params['remark'];
        // $userLevel->discount         = $params['level_discount'] ? $params['discount'] : '';
        // $userLevel->condition        = json_encode($condition,JSON_UNESCAPED_UNICODE);
        $userLevel->experience       = $params['experience'];
        $userLevel->save();
        return true;
    }


    /**
     * @notes 获取用户等级
     * @param $id
     * @return array
     */
    public function detail($id){
        $userLevel = UserLevel::find($id);
        
        $detail = [
            'id'                => $userLevel->id,
            'name'              => $userLevel->name,
            'rank'              => $userLevel->rank,
            'image'             => $userLevel->image,
            // 'background_image'  => $userLevel->background_image,
            'remark'            => $userLevel->remark,
            'level_discount'    => $userLevel->discount > 0 ? 1 :0,
            'discount'          => $userLevel->discount,
            'experience'          => $userLevel->experience,
            // 'condition'         => \app\common\logic\UserLogic::formatLevelCondition($userLevel->condition),
        ];

        return $detail;
    }

    /**
     * @notes 编辑会员等级
     * @param array $params
     */
    public function edit(array $params){
        $userlevel = UserLevel::find($params['id']);

        // if(isset($params['discount']) && $params['discount']==0){
        //     $params['discount']=0.00;
        // }

        $userlevel->name             = $params['name'];
        $userlevel->image            = $params['image'];
        // $userlevel->background_image = $params['background_image'];
        $userlevel->remark           = $params['remark'];
        // $userlevel->discount         =  $params['discount'];

        $userlevel->experience       = $params['experience'];

        // 按老板要求改成任何等级都可修改（但后期可能人为操作产生bug）
        $userlevel->rank       = $params['rank'];

        //非系统默认，可设置等级条件
        // if(1 != $userlevel->rank){
        //     $userlevel->rank            = $params['rank'];
        //     //等级条件
        //     $condition =$this->disposeCondition($params['condition']);
        //     $userlevel->condition    = json_encode($condition,JSON_UNESCAPED_UNICODE);
        // }

        $userlevel->save();
        return true;

    }

    /**
     * @notes 删除会员等级
     * @param int $id
     * @return bool
     */
    public function del(int $id){
        $res = UserLevel::destroy($id);
        //todo 将该等级的用户全部降到系统默认等级
        if($res){

            $level = UserLevel::where(['rank'=>1])->find();
            if($level){
                User::where(['level'=>$id])->update(['level'=>$level->id]);
            }

        }
        return true;
    }

    /**
     * @notes 处理前端传过来的等级数据
     * @param $condition
     * @author lgp
     * @date 2022/4/28 17:05
     */
    public function disposeCondition($condition){

        //默认满足任意条件
        $condition_type = $condition['condition_type'] ?? 0;
        //默认不勾选
        $isSingleMoney = $condition['is_single_money'];
        //单笔消费金额
        $singleMoney =$condition['single_money'] ?? '';
        //默认不勾选
        $isTotalMoney = $condition['is_total_money'];
        //累计消费金额
        $totalMoney = $condition['total_money'] ?? '';
        //默认不勾选
        $isTotalNum = $condition['is_total_num'];
        //累计消费次数
        $totalNum = $condition['total_num'] ?? '';

        return [
            'condition_type'        => (int)$condition_type,   //默认满足任意条件
            'is_single_money'       => (int)$isSingleMoney,    //默认不勾选
            'single_money'          => $singleMoney ? round($singleMoney,2) : '',
            'is_total_money'        => (int)$isTotalMoney,
            'total_money'           => $totalMoney ? round($totalMoney,2) : '',
            'is_total_num'          => (int)$isTotalNum,
            'total_num'             => $totalNum ?  (int)$totalNum : '',
        ];


    }

}