<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\goods;


use app\common\logic\BaseLogic;
use app\common\model\GoodsComment;

class GoodsCommentLogic extends BaseLogic
{
    /**
     * @notes 商家回复
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function reply($params)
    {
        $data = [];
        foreach ($params['id'] as $id) {
            $data[] = [
                'id' => $id,
                'reply' => $params['reply'],
            ];
        }
        $goods_comment = new GoodsComment;
        $goods_comment->saveAll($data);
        return true;
    }

    /**
     * @notes 删除评价
     * @param $params
     * @return bool
     */
    public function del($params)
    {
        return GoodsComment::destroy($params['id']);
    }

    /**
     * @notes 修改评价审核状态
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function status($params)
    {
        $data = [];
        foreach ($params['id'] as $id) {
            $data[] = [
                'id' => $id,
                'status' => $params['status'],
            ];
        }
        $goods_comment = new GoodsComment;
        $goods_comment->saveAll($data);
        return true;
    }
}