<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\auth;


use app\common\{
    model\DevAuth,
    logic\BaseLogic,
    enum\DefaultEnum
};

/**
 * 菜单逻辑层
 * Class MenuLogic
 * @package app\adminapi\logic\auth
 */
class MenuLogic extends BaseLogic
{
    /**
     * @notes 添加菜单权限
     * @param $params
     * @return bool
     */
    public function add(array $params)
    {

        $menuId = DevAuth::order('id desc')->value('id');
        $menu = new DevAuth;
        $menu->id       = $menuId+1;
        $menu->name     = $params['name'];
        $menu->uri      = $params['uri'];
        $menu->type     = $params['type'];
        $menu->pid      = $params['pid'];
        $menu->alias    = $params['alias'];
        $menu->icon     = $params['icon'] ?? '';
        $menu->sort     = $params['sort'] ?? DefaultEnum::SORT;
        $menu->disable  = $params['disable'];
        return $menu->save();
    }

    /**
     * @notes 编辑菜单权限
     * @param array $params
     * @return DevAuth
     */
    public function edit(array $params)
    {
        return DevAuth::update($params,[],['name','uri','type','pid','alias','icon','sort','disable']);

    }

    /**
     * @notes 删除菜单
     * @param int $id
     * @return bool
     */
    public function del(int $id)
    {
        DevAuth::where(['id'=>$id])->delete();
        return true;
    }
}