<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\system;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\settings\shop\ShopSettingLogic;


/**
 * 铭感词库设置
 * Class TransactionSettingsController
 * @package app\adminapi\controller\settings\order
 */
class DangerWord extends BaseAdminController
{
    /**
     * @notes 获取敏感词库
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $result = ShopSettingLogic::getDangerWordConfig();
        return $this->data($result);
    }

    /**
     * @notes 设置敏感词库
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = $this->request->post();
        ShopSettingLogic::setDangerWordConfig($params);
        return $this->success('设置成功');
    }
}