<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\app;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\lists\settings\app\UpgradeLists;
use app\adminapi\logic\settings\app\AppSettingLogic;

/**
 * APP设置控制器
 * Class AppSettingController
 * @package app\adminapi\controller\settings\app
 */
class AppSetting extends BaseAdminController
{
    /**
     * @notes 获取App设置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $result = AppSettingLogic::getConfig();
        return $this->data($result);
    }

    /**
     * @notes App设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = $this->request->post();
        AppSettingLogic::setConfig($params);
        return $this->success('设置成功', [], 1, 1);
    }


    /**
     * @notes 查看更新版本列表
     * @return \think\response\Json
     */
    public function getUpgradeLists()
    {
        return $this->dataLists( new UpgradeLists() );
    }

    /**
     * @notes 添加APP更新
     */
    public function upgradeAdd()
    {

        $params = $this->request->post();
        $result = AppSettingLogic::upgradeAdd($params);
        if ($result) {
            return $this->success('添加成功');
        }
        return $this->fail('添加失败');
    }


    /**
     * @notes 查看更新版本列表
     * @return \think\response\Json
     */
    public function upgradeDel()
    {
        $params = $this->request->get();
        $result = AppSettingLogic::upgradeDel($params);
        return $this->success($result);
    }

    
}