<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\order;


use app\adminapi\controller\BaseAdminController;
use app\adminapi\lists\order\OrderLists;
use app\adminapi\logic\order\OrderLogic;
use app\adminapi\validate\order\OrderValidate;
use app\common\service\JsonService;

class Order extends BaseAdminController
{
    /**
     * @notes 查看订单列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists(new OrderLists());
    }

    /**
     * @notes 查看其他列表
     * @return \think\response\Json
     */
    public function otherLists()
    {
        $result = (new OrderLogic())->otherLists();
        return $this->success('',$result);
    }

    /**
     * @notes 查看订单详情
     * @return \think\response\Json
     */
    public function detail()
    {
        $params = (new OrderValidate())->goCheck('detail');
        $result = (new OrderLogic())->detail($params);
        return $this->success('',$result);
    }

    /**
     * @notes 修改地址
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function addressEdit()
    {
        $params = (new OrderValidate())->post()->goCheck('AddressEdit', ['admin_id' => $this->adminId]);
        (new OrderLogic())->addressEdit($params);
        return $this->success('修改成功',[],1,1);
    }

    /**
     * @notes 设置商家备注
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function orderRemarks()
    {
        $params = (new OrderValidate())->post()->goCheck('OrderRemarks', ['admin_id' => $this->adminId]);
        (new OrderLogic())->orderRemarks($params);
        return $this->success('修改成功',[],1,1);
    }

    /**
     * @notes 修改价格(订单详情)
     * @return \think\response\Json
     */
    public function changePrice()
    {
        $params = (new OrderValidate())->post()->goCheck('ChangePrice', ['admin_id' => $this->adminId]);
        $result = (new OrderLogic())->changePrice($params);
        if (false === $result) {
            return $this->fail(OrderLogic::getError());
        }
        return $this->success('修改成功',[],1,1);
    }

    /**
     * @notes 修改运费(订单详情)
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function changeExpressPrice()
    {
        $params = (new OrderValidate())->post()->goCheck('ChangeExpressPrice', ['admin_id' => $this->adminId]);
        (new OrderLogic())->changeExpressPrice($params);
        return $this->success('修改成功',[],1,1);
    }

    /**
     * @notes 取消订单
     * @return \think\response\Json
     */
    public function cancel()
    {
        $params = (new OrderValidate())->post()->goCheck('cancel', ['admin_id' => $this->adminId]);
        $result = (new OrderLogic())->cancel($params);
        if (false === $result) {
            return $this->fail(OrderLogic::getError());
        }
        return $this->success('取消成功',[],1,1);
    }

    /**
     * @notes 发货
     * @return \think\response\Json
     */
    public function delivery()
    {
        $params = (new OrderValidate())->post()->goCheck('delivery', ['admin_id' => $this->adminId]);
        
        $result = (new OrderLogic())->delivery($params);
        if (false === $result) {
            return $this->fail(OrderLogic::getError());
        }
        return $this->success('发货成功',[],1,1);
    }

    /**
     * @notes 发货信息
     * @return \think\response\Json
     */
    public function deliveryInfo()
    {
        $params = (new OrderValidate())->goCheck('DeliveryInfo');
        $result = (new OrderLogic())->deliveryInfo($params);
        return $this->success('',$result);
    }

    /**
     * @notes 确认收货
     * @return \think\response\Json
     */
    public function confirm()
    {
        $params = (new OrderValidate())->post()->goCheck('confirm', ['admin_id' => $this->adminId]);
        (new OrderLogic())->confirm($params);
        return $this->success('操作成功',[],1,1);
    }

    /**
     * @notes 物流查询
     * @return \think\response\Json
     */
    public function logistics()
    {
        $params = (new OrderValidate())->goCheck('logistics');
        $result = (new OrderLogic())->logistics($params);
        return $this->success('',$result);
    }



    /**
     * @notes 修改物流信息
     * @return \think\response\Json
     * @author lgp
     * @date 2022/9/5 14:28
     */
    public function changeDelivery()
    {
        $params = $this->request->post();
        $result = (new OrderLogic())->changeDelivery($params);
        if(true === $result){
            return $this->success('修改成功',[],1,1);
        }
        return JsonService::fail($result);
    }
}