<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\group;

use app\adminapi\controller\BaseAdminController;

/**
 * 首页导航菜单
 * Class GoodsController
 * @package app\adminapi\controller\goods
 */
class GroupCategory extends BaseAdminController
{
    public function list()
    {
        $list = \app\common\model\GroupCategory::order('sort','desc')
        ->select()
        ->toArray();

        $list = linear_to_tree($list);
        
        return show(1,'',$list);
    }

    
    public function create()
    {
        $params = $this->request->post();
        $res = \app\common\model\GroupCategory::create($params);
        if(!$res){
            return show(0,'添加失败');
        };
        return show(1,'添加成功');
    }


    public function del($id)
    {
        $res = \app\common\model\GroupCategory::where('id',$id)->delete();
        if(!$res){
            return show(0,'删除失败');
        };
        return show(1,'删除成功');
    }

    public function detail($id)
    {
        $res = \app\common\model\GroupCategory::where('id',$id)->find();
        if(!$res){
            return show(0,'查询失败');
        };
        return show(1,'查询成功', $res);
    }


    /**
     * 修改
     * @return void
     */
    public function update()
    {
        $params = $this->request->post();
        $res = \app\common\model\GroupCategory::where('id',$params['id'])->update($params);
        if(!$res){
            return show(0,'未修改');
        };
        return show(1,'修改成功');
    }
}


