<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\collect\info;

use app\adminapi\controller\BaseAdminController;

/**
 * 西瓜分类信息-分类
 * Class UserController
 * @package app\adminapi\controller\user
 */
class InfoCollect extends BaseAdminController
{
    // DZ-西瓜/分类行业数据采集
    public function insertDZXG()
    {
        $list = $this->request->post('list');
        $page = $this->request->post('page');

        $saveData=[];

        $err=[];

        foreach($list as $v){
            
            // 判断用户是否存在
            $user=\app\common\model\User::where('dz_uid',$v['uid'])->find();
            if(!$user){
                $err[]=[
                    "msg"=>"请先采集用户",
                    "dz_uid"=>$v['uid'],
                ];
                continue;
            }
            // 将分类保存到圈子里
            $saveData[]=[
                "dz_id"=>$v['id'],
                "user_id"=>$user->id,
                "title"=>"",
                "image"=>"",//封面图,多个图片逗号分隔
                "mp3"=>"",
                "longitude"=>$v['lng']?$v['lng']*1000000:'',//经度
                "latitude"=>$v['lat']?$v['lat']*1000000:'',//纬度
                "content"=>$v['description'],//文章内容
                "ip"=>$v['ip'],
                "status"=>1,
                "visit"=>$v['views'],//浏览人数
                "share_count"=>$v['shares'],//分享次数
                "vars"=>json_encode($v['vars']),//字段原内容
                "create_time"=>strtotime($v['cr_time']),
                "contact_phone"=>$v['mobile'],//联系手机号
                "contact_name"=>$v['realname'],//联系人名字
                "contact_wechat"=>"",//联系人微信
                "cloud_url"=>"",
                "cloud_password"=>"",
            ];
        }


        try{

            $res = \think\facade\Db::name('article')
            ->extra('IGNORE')
            ->insertAll($saveData);

            // 记录当前页数 用于下次断点采集
            \app\common\service\ConfigService::set('InfoInfoCollect','dz_page',$page);

            return \show(1,'导入成功',$err);
        }catch(\Exception $e){
            return \show(0,'导入失败'.$e->getMessage());
        }

    }

    // 查询上一次采集到第几页
    public function dzPageRecord()
    {
        $page=\app\common\service\ConfigService::get('InfoInfoCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

    public function dzPageRecordDel()
    {
        $page=\app\common\service\ConfigService::set('InfoInfoCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

}