<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\enum\NoticeEnum;
use app\common\lists\BaseDataLists;
use app\common\model\Notice;

/**
 * 通知列表
 * Class NoticeLists
 * @package app\api\lists
 */
class NoticeLists extends BaseShopDataLists
{
    public function setSearch()
    {
        $this->searchWhere = [
            ['user_id', '=', $this->userId],
            ['send_type', '=', NoticeEnum::SYSTEM]
        ];
        // 系统通知
        if (isset($this->params['type']) && $this->params['type'] == 'system') {
            $this->searchWhere[] = [
                ['scene_id', 'in', [
                    NoticeEnum::ORDER_PAY_NOTICE,
                    NoticeEnum::ORDER_SHIP_NOTICE,
                    NoticeEnum::SELLER_ORDER_PAY_NOTICE,
                    NoticeEnum::SELLER_REFUND_APPLY_NOTICE,
                    NoticeEnum::REFUND_REFUSE_NOTICE,
                    NoticeEnum::REFUND_SUCCESS_NOTICE,
                    NoticeEnum::ARTICLE_EXAMINE_NOTICE,
                    ]
                ]
            ];
        }

        // 关注我
        if (isset($this->params['type']) && $this->params['type'] == 'follow') {
            $this->searchWhere[] = [
                ['scene_id', '=',  NoticeEnum::FOLLOW_NOTICE]
            ];
        }

        // 收藏
        if (isset($this->params['type']) && $this->params['type'] == 'collect') {
            $this->searchWhere[] = [
                ['scene_id', '=',  NoticeEnum::ARTICLE_COLLECT_NOTICE]
            ];
        }

        if (isset($this->params['type']) && $this->params['type'] == 'comment') {
            $this->searchWhere[] = [
                ['scene_id', '=',  NoticeEnum::ARTICLE_COMMENT_NOTICE]
            ];
        }

        // 会员接收的公告
        if (isset($this->params['recipient'])) {
            $this->searchWhere[] = [
                ['recipient', '=',  $this->params['recipient']]
            ];
        }

    }

    /**
     * @notes 列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $this->setSearch();
        $lists = Notice::field('id,title,content,create_time,extra,read')
            ->where($this->searchWhere)
            ->order('id', 'desc')
            ->limit($this->limitOffset, $this->limitLength)
            ->select()
            ->toArray();
            
        $type = input('type');
        
        if($type == 'comment' || $type == 'collect'){
            // 查询评论内容
            foreach($lists as &$v){
                if (!json_decode($v['extra'],true)) {
                    goto next;
                }
                $params = json_decode($v['extra'],true)['params'];
                $v['from_user'] = \app\common\model\User::field('id,avatar,nickname')->find($params['fans_id']);
                $v['article'] = \app\common\model\Article::field('id,title,image,content')->find($params['article_id']);
                // dd($params);
                if(isset($params['content_id'])){
                    $isCollect = \app\common\model\UserCollect::where([ 'type' => 3, 'comments_id' => $params['content_id'], 'aid' => $params['article_id'], 'user_id' => $this->userId])->value('id');
                    $v['is_collect'] = $isCollect ? 1 : 0;
                }
            }
        }elseif($type == "follow"){
            // 查询评论内容
            foreach($lists as &$v){
                if (!json_decode($v['extra'],true)) {
                    goto next;
                }
                $params = json_decode($v['extra'],true)['params'];
                $v['from_user'] = \app\common\model\User::field('id,avatar,nickname')->find($params['fans_id']);

                // 判断有无关注
                $isFollow = \app\common\model\UserFollow::where([ 'follow_user_id' => $params['fans_id'], 'user_id' => $params['user_id']])->value('id');
                $v['is_follow'] = $isFollow ? 1 : 0;
            }
        }
        next:

        if($type){
            $scene_id  = null;
            switch($type){
                case 'follow':
                    $scene_id = [NoticeEnum::FOLLOW_NOTICE];
                    break;
                case 'collect':
                    $scene_id = [NoticeEnum::ARTICLE_COLLECT_NOTICE];
                    break;
                case 'comment':
                    $scene_id = [NoticeEnum::ARTICLE_COMMENT_NOTICE];
                    break;
                case 'system':
                    $scene_id = [
                        NoticeEnum::ORDER_PAY_NOTICE,
                        NoticeEnum::ORDER_SHIP_NOTICE,
                        NoticeEnum::SELLER_ORDER_PAY_NOTICE,
                        NoticeEnum::SELLER_REFUND_APPLY_NOTICE,
                        NoticeEnum::REFUND_REFUSE_NOTICE,
                        NoticeEnum::REFUND_SUCCESS_NOTICE,
                        NoticeEnum::ARTICLE_EXAMINE_NOTICE,
                    ];
                    break;
            }

            Notice::where('scene_id','in',$scene_id)
            ->where('user_id',$this->userId)
            ->update([
                'read'=>1
            ]);
        }

        // dd($lists);
        
        return $lists;
    }

    /**
     * @notes 记录数
     * @return int
     */
    public function count(): int
    {
        $this->setSearch();
        $count = Notice::where($this->searchWhere)->count();

        return $count;
    }
}
