<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║
 *  ║                                                   ║
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;
use think\facade\Db;

/**
 * 举报
 */
class Report extends BaseShopController
{

    public function categroyList()
    {
        $params = $this->request->param();

        $where = [];

        if (isset($params['type'])) {
            $where[] = ['type', '=', $params['type']];
        }

        $lists = \app\common\model\ReportCategory::field('id,name,description,pid')
            ->where($where)
            ->order(['id'=>'desc'])
            ->select()
            ->toArray();

        $lists = linear_to_tree($lists,'sons');

        return show(config('status.success'),'分类',$lists);
    }

    public function categroyDetail($id)
    {
        $res = \app\common\model\ReportCategory::where('id', $id)
            ->whereOr('pid', $id)
            ->order('pid asc')
            ->select();

        linear_to_tree($res,'sons');

        return show(1, '', $res[0]);
    }

    /**
     * 举报分类
     */
    public function list()
    {
        $list = \app\common\model\Report::where('status.success')
            ->append(['categories', 'item'])
            ->order(['create_time'=>'desc'])
            ->select()
            ->toArray();

        $list = linear_to_tree($list);

        return show(config('status.success'),'分类列表',$list);
    }

    public function detail($id)
    {
        $res = \app\common\model\Report::where('id', $id)
            ->where('user_id', $this->userId)
            ->append(['categories', 'item'])
            ->find();

        if (!$res) {
            return show(0, '查询失败');
        }

        return show(1, '查询成功', $res);
    }

    // 提交举报
    public function add()
    {
        $params = $this->request->post();

        $data = [
            'category_id'=>$params['category_id'],
            'user_id'=>$this->userId,
            'content'=>$params['content'],
            'reported_content_id'=>$params['reported_content_id'],//被举报id
            'reported_content_type'=>$params['reported_content_type'],//被举报类型：article group user
            'evidence'=>$params['evidence'],//证据(图片/视频等URL)
            'ip_address'=>$this->request->ip()
        ];

        \app\common\model\Report::create($data);

        return show(config('status.success'),'提交成功');

    }

    /**
     * 我提交的举报
     */
    public function mylist()
    {
        $list = \app\common\model\Report::where('user_id', $this->userId)
            ->append(['categories', 'item'])
            ->paginate(10);

        return show(config('status.success'),'我的提交列表',$list);
    }

    public function del($id)
    {
        $res = \app\common\model\Report::where('id', $id)
            ->where('user_id', $this->userId)
            ->delete();

        if (!$res) {
            return show(0, '撤诉失败');
        }

        return show(1, '撤诉成功');
    }


}
