<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;

/**
 * 搭子
 * Class OrderController
 * @package app\api\controller
 */
class Partner extends BaseShopController
{
    
    public array $notNeedLogin = ['list'];

    /**
     * 搭子分类
     */
    public function categoryList()
    {
        $list = \app\common\model\PartnerCategory::where('status',1)
        ->order('sort','desc')
        ->select()
        ->toArray();

        return \show(\config('status.success'),'',$list);
    }


    public function createPartner()
    {
        $params = $this->request->post();

        $data = [
            'user_id'=> $this->userId,
            'category_id'=> $params['category_id'],
            'title'=>$params['title'],
            'description'=>$params['description'],
            'location'=>$params['location'],
            'activity_time'=>$params['activity_time'],
            'duration'=>$params['duration'],
            'max_participants'=>$params['max_participants'],
            'current_participants'=>$params['current_participants'],
            'is_public'=>$params['is_public'],
            'price'=>$params['price'],
            'status'=>1,//1=可报名,2=已结束
            'longitude'=>$params['longitude'],
            'latitude'=>$params['latitude'],
            'start_time'=>$params['start_time'],
            'image'=>$params['image'],
        ];

        $res = \app\common\model\Partner::create($data);

        if(!$res){
            return \show(config('status.error'),'添加失败');
        }

        return \show(config('status.success'),'添加成功');
        
    }

    public function list()
    {
        $params = $this->request->get();

        $where = [];

        if(isset($params['category_id'])){
            $where[] = ['category_id','=',$params['category_id']];
        }

        if(isset($params['user_id'])){
            $where[] = ['user_id','=',$params['user_id']];
        }

        $list = \app\common\model\Partner::with(['user'])
        ->where($where)
        ->order(['id'=>'desc'])
        ->paginate(20);

        return show(config('status.success'),'',$list);

    }


    /**
     * 创建搭子订单
     */
    public function createOrder()
    {

        $params = $this->request->post();
        
        $partner = \app\common\model\Partner::find($params['partner_id']);

        $member_count = \app\common\model\PartnerMember::where([
            ['partner_id','=',$params['partner_id']],
            ['create_time','<',$partner->start_time]
        ])->count();

        if($partner->start_time > time()){
            return \show(config('status.error'),'报名时间还未开始');
        }

        // 判断参与人数
        if($member_count >= $partner->max_participants){
            return \show(config('status.error'),'超出最大人数限制');
        }

        // 判断时间
        if(time() >= $partner->activity_time){
            return \show(config('status.error'),'活动已开始无法报名');
        }

        if($partner->status !=1){
            return \show(config('status.error'),'获取已结束或已取消/或不可用');
        }
        
        $data = [
            'user_id'=>$this->userId,
            'sell_user_id'=>$partner->user_id,
            'sn'            => time().rand(00000,99999),
            'terminal'      => $this->userInfo['terminal'],
            'pay_status'    => \app\common\enum\PayEnum::UNPAID,
            'pay_way'       => $params['pay_way'] ?? 2,
            'order_amount'  => $partner->price,
            'partner_id'    => $params['partner_id']
        ];

        $order = \app\common\model\PartnerOrder::create($data);
        if(!$order){
            return show(config('status.error'),'error');
        }

        return show(config('status.success'),'ok',[
            'order_id' => $order->id,
            'from' => 'partner'
        ]);

    }

    

    /**
     * 查询用户购买的订单
     */
    public function userOrder()
    {
        $params = $this->request->post();
        $where = [];

        if(isset($params['status'])){
            $where[]=['status','=',$params['status']];
        }

        $list = \app\common\model\PartnerOrder::with(['partner'])
        ->where('user_id',$this->userId)
        ->where($where)
        ->order('create_time','desc')
        ->paginate(20);

        return show(config('status.success'),'',$list);
    }

    /**
     * 查询商家卖出的商品订单
     */
    public function SellOder()
    {
        $params = $this->request->post();
        $where = [];

        if(isset($params['status'])){
            $where[]=['status','=',$params['status']];
        }

        $list = \app\common\model\PartnerOrder::with(['partner'])
        ->where('sell_user_id',$this->userId)
        ->where($where)
        ->order('create_time','desc')
        ->paginate(20);

        return show(config('status.success'),'',$list);
    }

    
    /**
     * 添加评论
     */
    public function addConmment()
    {
        $params = $this->request->post();

        // 判断已评论不能再评论
        $comment =  \app\common\model\PartnerComment::where('order_id',$params['order_id'])
        ->find();

        if(!$comment){
            return \show(\config('status.error'),'已评价过了,请勿重复评价');
        }

        $order = \app\common\model\PartnerComment::find($params['order_id']);
        $data = [
            'goods_id'=>$order->goods_id,
            'order_id'=>$params['order_id'],
            'user_id'=>$this->userId,
            'sell_user_id'=>$order->sell_user_id,
            'partner_comment'=>$params['partner_comment'],  
            'service_comment'=>$params['service_comment'],
            'description_comment'=>$params['description_comment'],
            'express_comment'=>$params['express_comment'],
            'comment'=>$params['comment'],
            
            'status'=>1,//审核通过
        ];

        $res = \app\common\model\PartnerComment::create($data);

        if(!$res){
            return \show(\config('status.error'),'添加失败');
        }

        return show(config('status.success'),'添加成功');

        
    }

    /**
     * 评论列表查询
     */
    public function commentList()
    {
        $params = $this->request->get();


        if(isset($params['order_id'])){
            $where[]=['order_id','=',$params['order_id']];
        }

        if(isset($params['partner_id'])){
            $where[]=['partner_id','=',$params['partner_id']];
        }

        if(isset($params['sell_user_id'])){
            $where[]=['sell_user_id','=',$params['sell_user_id']];
        }

        if(isset($params['status'])){
            $where[]=['status','=',$params['status']];

            if($params['status']!=1){
                $where[]=['user_id','=',$this->userId];
            }
        }

        $list = \app\common\model\PartnerComment::where($where)
        ->order('id','desc')
        ->paginate(20);

        return \show(\config('status.success'),'',$list);
    }

    /**
     * 搭子详情
     */
    public function partnerDetails($id)
    {
        $data = \app\common\model\Partner::with(['member', 'user'])->find($id);

        return \show(config('status.success'),'',$data);
    }
    

}