<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;

use app\api\lists\ArticleLists;
use app\common\logic\ChatLogic;
use app\api\logic\DecorateThemeLogic;
use app\api\logic\IndexLogic;

/**
 * 商圈相关
 * Class IndexController
 * @package app\api\controller
 */
class Business extends BaseShopController
{ 
    /**
     * 查询所有商圈用户
     * @return void
     */
    public function list()
    {
        $list = \app\common\model\Business::with('user')
        ->select()
        ->toArray();
        return show(config('status.success'),'商户列表',$list);
    }

    /**
     * 查询分类
     */
    public function category()
    {
        $list = \app\common\model\BusinessCategory::select()
        ->toArray();
        return show(config('status.success'),'商户列表',$list);
    }

    /**
     * 申请成为商圈商户
     */
    public function create()
    {

    }

}
