<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\ad;

use app\common\model\AdPosition;
use app\common\enum\AdEnum;
use app\common\logic\BaseLogic;
use app\common\model\Ad;
use app\common\service\FileService;
use think\facade\Db;

/**
 * 广告位逻辑层
 * Class AdLogic
 * @package app\adminapi\logic\AdLogic
 */
class AdLogic extends BaseLogic
{
    
    public static function otherList($params){

        
        return AdPosition::where([
            'status' => AdEnum::STATUS_OPEN,
            'client' => $params['client']
            ])->field('id,name')->select()->toArray();
    }
    /**
     * @notes 查看详情
     * @param $params
     * @return string[]
     */
    public static function detail($params)
    {
        $data = Ad::findOrEmpty($params['id'])->toArray();
        return  $data;
    }

    /**
     * @notes 添加
     * @param $params
     */
    public static function add($params)
    {
        $image = isset($params['image']) && !empty($params['image']) ? FileService::setFileUrl($params['image']) : '';
        $data = [
            'name'     => $params['name'],
            'pid'       => $params['pid'],
            'link_type' => $params['link_type'],
            'link'      => $params['link'] ?? '',
            'image'     => $image,
            'sort'      => $params['sort'] ,
            'status'    => $params['status'],
            'client'    => AdEnum::mobile,
            'create_time' => time()
        ];

        return Ad::create($data);
    }

    /**
     * @notes 编辑
     * @param $params
     */
    public static function edit($params)
    {
        $image = isset($params['image']) && !empty($params['image']) ? FileService::setFileUrl($params['image']) : '';

        $data = [
            'name'     => $params['name'],
            'pid'       => $params['pid'],
            'link_type' => $params['link_type'],
            'link'      => $params['link'] ?? '',
            'image'     => $image,
            'sort'      => $params['sort'] ,
            'status'    => $params['status'],
            'update_time' => time()
        ];

        return  Ad::update($data,['id' => $params['id']]);
    }

    /**
     * @notes 删除
     * @param $params
     */
    public static function delete($params)
    {
        return Ad::destroy($params['id']);
    }

    /**
     * @notes 修改是否显示状态
     * @param $params
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function status($params)
    {
        $article = Ad::find($params['id']);
        $article->save(['status' => $params['status']]);
    }

    
}