<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\topic;

use app\adminapi\controller\BaseAdminController;

use app\common\service\ConfigService;

/**
 * 话题设置
 * Class TransactionSettingsController
 * @package app\adminapi\controller\settings\order
 */
class Topic extends BaseAdminController
{
    /**
     * @notes 获取话题设置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        return [
            'topic_name'=>ConfigService::get('topic', 'topic_name','话题'),
        ];
        return $this->data($result);
    }

    /**
     * @notes 交易设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = $this->request->post();
        ConfigService::set('topic', 'topic_name', $params['topic_name'] ?? '话题');
        return $this->success('设置成功');
    }
}