<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\chat;

use app\adminapi\controller\BaseAdminController;
use \think\facade\Db;

/**
 * 
 */
class PrivateChat extends BaseAdminController
{
    /**
     * 
     */
    public function list()
    {
       $list = \app\common\model\ChatPrivateMessage::with(['fromUser','toUser'])
       ->paginate(10);
       return show(config('status.success'),'list',$list);
    }

    /**
      * 聊天记录
    */
    public function chat()
    {
        $params = $this->request->get();
        $list = \app\common\model\ChatPrivateMessage::with(['fromUser','redPackets','transfers'])
        ->where([
            'from_id'=>$params['from_id'],
            'to_id'=>$params['to_id']
        ])
        ->order('create_time','desc')
        ->paginate(10);

        return show(config('status.success'),'ok',$list);
    }

    /**
     * 修改
     * @return void
     */
    public function update()
    {
        $params = $this->request->post();
        $res = \app\common\model\ChatPrivateMessage::where('id',$params['id'])->update($params);
        if(!$res){
            return show(0,'修改失败');
        };
        return show(1,'修改成功');
    }

    /**
     * 聊天记录删除
     */
    public function del($id)
    {
        $res = \app\common\model\ChatPrivateMessage::where('id',$id)->delete();
        if(!$res){
            return show(0,'删除失败');
        };
        return show(1,'删除成功');
    }

}
