<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║
 *  ║                                                   ║
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller;

class RealVerify extends BaseAdminController
{
    public function list()
    {
        $params = $this->request->post();
        $where = [];

        if (isset($params['user_id'])) {
            $where[] = [
                'user_id', '=', $params['user_id']
            ];
        }

        if (isset($params['type_id'])) {
            $where[] = [
                'type_id', '=', $params['type_id']
            ];
        }

        $list = \app\common\model\RealVerify::where($where)
            ->with([
                'user' => function ($query) {
                    $query->field('id,nickname');
                },
                'type' => function ($query) {
                    $query->field('id,name');
                },
                'fields' => function ($query) {
                    $query->with('typeField');
                }
            ])
            ->paginate(20)
            ->toArray();

        return show(1, '', $list);
    }

    public function create()
    {
        $params = $this->request->post();
        $res = \app\common\model\RealVerify::create($params);
        if (!$res) {
            return show(0, '添加失败');
        };
        return show(1, '添加成功');
    }

    public function del($id)
    {
        \app\common\model\RealVerify::destroy($id);

        return show(config('status.success'), '删除成功');
    }

    public function detail($id)
    {
        $res = \app\common\model\RealVerify::where('id', $id)
            ->with([
                'user' => function ($query) {
                    $query->field('id,nickname');
                },
                'type' => function ($query) {
                    $query->field('id,name');
                },
                'fields' => function ($query) {
                    $query->with('typeField');
                }
            ])
            ->find();
        if (!$res) {
            return show(0, '查询失败');
        };
        $res = $res->toArray();
        return show(1, '查询成功', $res);
    }


    public function update()
    {
        $params = $this->request->post();
        $res = \app\common\model\RealVerify::where('id', $params['id'])->update($params);
        if (!$res) {
            return show(0, '修改失败');
        };
        return show(1, '修改成功');
    }
}