<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

use app\adminapi\lists\ArticleCommentLists;
use app\adminapi\lists\CircleLists;
use app\adminapi\lists\CircleCateLists;
use app\adminapi\lists\TopicLists;
use app\adminapi\validate\ArticleValidate;
use app\adminapi\logic\ArticleLogic;
use app\adminapi\logic\CircleLogic;
use app\adminapi\logic\CircleCateLogic;
use app\adminapi\logic\TopicLogic;

class ArticleRandImage extends BaseAdminController
{

    /**
     * 添加帖子随机图片
     */
    public function add()
    {
        $params = $this->request->post();
        (new \app\common\model\ArticleRandImage())->saveAll($params);
        return show(config('status.success'),'添加成功');
    }

    /**
     * 删除帖子随机图片
     */
    public function del($id)
    {
        \app\common\model\ArticleRandImage::where('id',$id)->delete();
        return show(config('status.success'),'删除');
    }

    /**
     * 清空所有帖子随机图片
     */
    public function delAll()
    {
        \app\common\model\ArticleRandImage::select()->delete();
        return show(config('status.success'),'删除');
    }

    /**
     * 查询所有帖子随机图片
     */
    public function list()
    {
        $list = \app\common\model\ArticleRandImage::select();
        return show(config('status.success'),'随机图片',$list);
    }

    
}