<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║
 *  ║                                                   ║
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
declare (strict_types=1);

namespace app\common\model;

use think\Model;

/**
 * @mixin \think\Model
 */
class Merchant extends Model
{
    public $append = ['categories'];

    // 商家认证提交的表单内容
    public function formSubmission()
    {
        // return $this->hasMany(formSubmissionDetails::class,'');
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id')->field('id,nickname,avatar');
    }

    public function category()
    {
        return $this->hasOne(MerchantCategory::class, 'id', 'category_id')->field('id,name,pid');
    }

    public function getCategoriesAttr()
    {
        $result = [];

        $category = $this->category;

        while (true) {
            $result[] = $category;
            if ($category && $category->pid) {
                $category = MerchantCategory::find($category->pid);

                if (!$category) {
                    break;
                }
            } else {
                break;
            }
        }

        return array_reverse($result);
    }
}
