<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;


use app\common\model\Article;
use app\common\model\ArticleDraft;

class ArticleDraftLists extends BaseShopDataLists 
{

    /**
     * @notes 设置搜索
     */
    public function setSearch()
    {

        $this->searchWhere[] = ['user_id' , '=' , $this->userId];
    }


    /**
     * @notes 文章/帮助列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {        
        $this->setSearch();
        
        $lists = ArticleDraft::where($this->searchWhere)
            ->limit($this->limitOffset, $this->limitLength)
            ->select()->toArray();

        return $lists;
    }

    /**
     * @notes 文章/帮助总记录数
     * @return int
     */
    public function count(): int
    {
        $this->setSearch();
        
        $count = ArticleDraft::where($this->searchWhere);

        return $count->count();
    }
}