<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\wechat;

use app\common\logic\BaseLogic;
use app\common\service\ConfigService;
use app\common\service\FileService;

/**
 * 微信小程序设置逻辑层
 * Class MiniProgramSettingLogic
 * @package app\adminapi\logic\wechat
 */
 class MiniProgramSettingLogic extends BaseLogic
{
    public static function getConfig()
    {
        $domainName = $_SERVER['HTTP_HOST'];
        $qrCode = ConfigService::get('mini_program', 'qr_code', '');
        $qrCode = empty($qrCode) ? $qrCode : FileService::getFileUrl($qrCode);
        $config = [
            'name'                  => ConfigService::get('mini_program', 'name', ''),
            'original_id'           => ConfigService::get('mini_program', 'original_id', ''),
            'qr_code'               => $qrCode,
            'app_id'                => ConfigService::get('mini_program', 'app_id', ''),
            'app_secret'            => ConfigService::get('mini_program', 'app_secret', ''),
            'request_domain'        => 'https://'.$domainName,
            'socket_domain'         => 'wss://'.$domainName,
            'upload_file_domain'    => 'https://'.$domainName,
            'download_file_domain'  => 'https://'.$domainName,
            'udp_domain'            => 'udp://'.$domainName,
            'tcp_domain'            => 'tcp://'.$domainName,
            'business_domain'       => $domainName,

            'notice_chat_template_id'       => ConfigService::get('mini_program', 'notice_chat_template_id', ''),
            'notice_comment_template_id'       => ConfigService::get('mini_program', 'notice_comment_template_id', ''),
        ];

        return $config;
    }

    /**
     * @notes 微信小程序设置
     * @param $params
     */
    public static function setConfig($params)
    {
        $qrCode = isset($params['qr_code']) ? FileService::setFileUrl($params['qr_code']) : '';

        ConfigService::set('mini_program','name', $params['name'] ?? '');
        ConfigService::set('mini_program','original_id',$params['original_id'] ?? '');
        ConfigService::set('mini_program','qr_code',$qrCode);
        ConfigService::set('mini_program','app_id',$params['app_id']);
        ConfigService::set('mini_program','app_secret',$params['app_secret']);

        ConfigService::set('mini_program','notice_chat_template_id',$params['notice_chat_template_id']);
        ConfigService::set('mini_program','notice_comment_template_id',$params['notice_comment_template_id']);
    }
}