<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */



namespace app\adminapi\controller\wechat;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\wechat\MiniProgramSettingLogic;
use app\adminapi\validate\wechat\MiniProgramSettingValidate;

use app\common\service\ConfigService;

/**
 * 微信小程序设置控制器
 * Class MiniProgramSettingController
 * @package app\adminapi\controller\wechat
 */
class MiniProgramSetting extends BaseAdminController
{
    /**
     * @notes 获取微信小程序设置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $result = MiniProgramSettingLogic::getConfig();

        // 开放平台
        $result['open_app_id'] = ConfigService::get('mini_program', 'open_app_id', '');
        $result['open_app_secret'] = ConfigService::get('mini_program', 'open_app_secret', '');

        return $this->data($result);
    }

    /**
     * @notes 微信小程序设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = (new MiniProgramSettingValidate())->post()->goCheck();
        MiniProgramSettingLogic::setConfig($params);

        // 开放平台
        ConfigService::set('mini_program','open_app_id', $params['open_app_id'] ?? '');
        ConfigService::set('mini_program','open_app_secret',$params['open_app_secret'] ?? '');
        
        return $this->success('设置成功', [], 1, 1);
    }
}