<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\order;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\settings\order\TransactionSettingsLogic;
use app\adminapi\validate\settings\order\TransactionSettingsValidate;

/**
 * 交易设置控制器
 * Class TransactionSettingsController
 * @package app\adminapi\controller\settings\order
 */
class TransactionSettings extends BaseAdminController
{
    /**
     * @notes 获取交易设置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $result = TransactionSettingsLogic::getConfig();
        return $this->data($result);
    }

    /**
     * @notes 交易设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = (new TransactionSettingsValidate())->post()->goCheck();
        TransactionSettingsLogic::setConfig($params);
        return $this->success('设置成功');
    }
}