<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\collect;

use app\adminapi\controller\BaseAdminController;

/**
 * 商家用户数据采集
 * Class UserController
 * @package app\adminapi\controller\user
 */
class MerchantCollect extends BaseAdminController
{
    // DZ-西瓜/分类行业数据采集
    public function insertDZXG()
    {
        $list = $this->request->post('list');
        $page = $this->request->post('page');

        $saveData=[];

        $err=[];

        foreach($list as $v){

            // 查询商家用户id
            $user=\app\common\model\User::where("dz_uid",$v['uid'])->find();
            if(!$user){
                $err[]=[
                    "msg"=>"本地没有找到这个商户的用户，请先采集dz的用户",
                    "dz_uid"=>$v['uid'],
                ];
                continue;
            }

            // dd($user);

            // 查找这个商家的分类/行业id
            $category=\app\common\model\MerchantCategory::where("id",$v['hangye_id2'])
            ->find();
            if(!$category){
                $err[]=[
                    "msg"=>"本地未采集行业分类，请先采集行业分类",
                    "hangye_id2"=>$v['hangye_id2'],
                ];
                continue;
            }

            // dd($category);

            // 查找这个商家的vip $saveData
            $vip=\app\common\model\MerchantVipLevel::where("id",$v['viptype'])
            ->find();
            if(!$vip){
                $err[]=[
                    "msg"=>"本地未采集vip数据，请先采集vip",
                    "viptype"=>$v['viptype'],
                ];
                continue;
            }

            // dd($v['album']);

            $saveData[]=[
                "id"=>$v['shid'],
                "user_id"=>$user->id,
                "category_id"=>$category->id,
                "name"=>$v['name'],
                "phone"=>$v['tel'],
                "email"=>"",
                "wechat_code"=>"",
                "province"=>$v['province'],//所在省份
                "city"=>$v['city'],//所在城市
                "district"=>$v['district'],//所在区县
                "address"=>$v['addr'],//详细地址
                "longitude"=>$v['lng']*1000000,//经度
                "latitude"=>$v['lat']*1000000,//纬度
                "logo"=>$v['logo'],//商家logo URL
                "mp4"=>"",//宣传视频
                "desc"=>$v['jieshao'],//商家描述
                "opening_hours"=>$v['opentime'],//营业时间
                "status"=>$v['dongjie']==1?2:1,//状态：0-待审核，1-正常，2-拒审
                "create_time"=>$v['crts'],
                "bond"=>0,//保证金
                "qualifications"=>"",//资质
                "person"=>"",//法人代表
                "license"=>"",//营业执照
                "id_card_number"=>"",//身份证号(个人必填)
                "label_ids"=>"",
                "region_id"=>"",//运营地址库id红梅裁缝
                "city_id"=>0,
                "images"=>implode(',',$v['album']),
                "scale"=>"",
                "reject_reason"=>"",
                "visit_count"=>0,
                "share_count"=>0,
                "vip_id"=>$vip->id,
                "vip_expires"=>"",
                "vip_order_id"=>"",
            ];
        }

        // dd($saveData);

        try{

            $res = \think\facade\Db::name('merchant')
            ->extra('IGNORE')
            ->insertAll($saveData);

            // $res=\app\common\model\Merchant::insertAll($saveData);

            // dd($res);

            // 记录当前页数 用于下次断点采集
            \app\common\service\ConfigService::set('MerchantCollect','dz_page',$page);

            return \show(1,'导入成功',$err);
        }catch(\Exception $e){
            return \show(0,'导入失败'.$e->getMessage());
        }
        
    }

    // 查询上一次采集到第几页
    public function dzPageRecord()
    {
        $page=\app\common\service\ConfigService::get('MerchantCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

    public function dzPageRecordDel()
    {
        $page=\app\common\service\ConfigService::set('MerchantCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

}