<?php

namespace app\adminapi\controller\after_sale;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\after_sale\AfterSaleLogic;
use app\adminapi\validate\after_sale\AfterSaleValidate;

use EasyWeChat\Factory;
use think\facade\Log;

/**
 * 售后控制器
 * Class AfterSaleController
 * @package app\adminapi\controller\after_sale
 */
class AfterSale extends BaseAdminController
{
    /**
     * @notes 查看售后列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists();
    }

    /**
     * @notes 卖家同意售后
     * @return \think\response\Json
     */
    public function agree()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('agree');
        $params['admin_id'] = $this->adminId;
        $result = AfterSaleLogic::agree($params);
        if($result) {
            return  $this->success('卖家同意售后', [], 1, 1);
        }
        return $this->fail(AfterSaleLogic::getError());
    }

    /**
     * @notes 卖家拒绝售后
     * @return \think\response\Json
     */
    public function refuse()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('refuse');
        $params['admin_id'] = $this->adminId;
        $result = AfterSaleLogic::refuse($params);
        if($result) {
            return  $this->success('卖家拒绝售后', [], 1, 1);
        }
        return $this->fail(AfterSaleLogic::getError());
    }

    /**
     * @notes 卖家拒绝收货
     * @return \think\response\Json
     */
    public function refuseGoods()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('refuseGoods');
        $params['admin_id'] = $this->adminId;
        $result = AfterSaleLogic::refuseGoods($params);
        if($result) {
            return  $this->success('卖家拒绝收货', [], 1, 1);
        }
        return $this->fail(AfterSaleLogic::getError());
    }

    /**
     * @notes 卖家确认收货
     * @return \think\response\Json
     */
    public function confirmGoods()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('confirmGoods');
        $params['admin_id'] = $this->adminId;
        $result = AfterSaleLogic::confirmGoods($params);
        if($result) {
            return  $this->success('卖家确认收货', [], 1, 1);
        }
        return $this->fail(AfterSaleLogic::getError());
    }

    /**
     * @notes 卖家同意退款
     * @return \think\response\Json
     */
    public function agreeRefund()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('agreeRefund');
        $params['admin_id'] = $this->adminId;
        $result = AfterSaleLogic::agreeRefund($params);
        if($result) {
            return  $this->success('卖家同意退款', [], 1, 1);
        }
        return $this->fail(AfterSaleLogic::getError());
    }

    /**
     * @notes 卖家拒绝退款
     * @return \think\response\Json
     */
    public function refuseRefund()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('refuseRefund');
        $params['admin_id'] = $this->adminId;
        $result = AfterSaleLogic::refuseRefund($params);
        if($result) {
            return  $this->success('卖家拒绝退款', [], 1, 1);
        }
        return $this->fail(AfterSaleLogic::getError());
    }

    /**
     * @notes 卖家确认退款
     * @return \think\response\Json
     */
    public function confirmRefund()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('confirmRefund');
        $params['admin_id'] = $this->adminId;
        $result = AfterSaleLogic::confirmRefund($params);
        if($result) {
            return  $this->success('卖家确认退款', [], 1, 1);
        }
        return $this->fail(AfterSaleLogic::getError());
    }

    /**
     * @notes 查看售后详情
     * @return \think\response\Json
     */
    public function detail()
    {
        $params = (new AfterSaleValidate())->goCheck('detail');
        $result = AfterSaleLogic::detail($params);
        return $this->data($result);
    }
}