<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller;

use app\adminapi\logic\WorkbenchLogic;

/**
 * 工作台
 * Class WorkbenchCotroller
 * @package app\adminapi\controller
 */
class Workbench extends BaseAdminController
{
    /**
     * @notes 工作台
     * @return \think\response\Json
     */
    public function index()
    {
        $result = WorkbenchLogic::index($this->adminInfo);
        return $this->data($result);
    }

    /**
     * @notes 帖子排行榜 
     * @return \think\response\Json
     */
    public function topArticleTop50()
    {
        $params = request()->get();
        $params['page_no'] = isset($params['page_no']) && !empty($params['page_no']) ? (int)$params['page_no']: 1;
        $params['page_size'] = isset($params['page_size']) && !empty($params['page_size']) ? (int)$params['page_size']: 10;
        $params['page_size'] = $params['page_size'] > 50 ? 50 : $params['page_size']; // 限制每页最多显示50条
        $result = WorkbenchLogic::topArticleTop50($params);
        return $this->data($result);
    }

    /**
     * @notes 商品销量排行榜 - 按销量
     * @return \think\response\Json
     */
    public function topGoods50()
    {
        $params = request()->get();
        $params['page_no'] = isset($params['page_no']) && !empty($params['page_no']) ? (int)$params['page_no']: 1;
        $params['page_size'] = isset($params['page_size']) && !empty($params['page_size']) ? (int)$params['page_size']: 10;
        $params['page_size'] = $params['page_size'] > 50 ? 50 : $params['page_size']; // 限制每页最多显示50条
        $result = WorkbenchLogic::topGoods50($params);
        return $this->data($result);
    }
}