<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

/**
 * 提现
 */
class Withdrawal extends BaseAdminController
{

    public function list()
    {
        $params = $this->request->get();
        $where = [];

        if(isset($params['status'])){
            $where['status']=$params['status'];
        }

        $list = \app\common\model\UserWithdrawal::with(['user'])
        ->where($where)
        ->order('create_time','descs')
        ->paginate(20);

        return show(config('status.success'),'',$list);
    }


    /**
     * 同意打款
     */
    public function agree($id)
    {
        \app\common\model\UserWithdrawal::update(['status'=>1],['id'=>$id]);

        return show(config('status.success'),'设置成功');
    }

    
    public function detail($id)
    {
        $res = \app\common\model\UserWithdrawal::where('id',$id)->find();
        if(!$res){
            return show(0,'查询失败');
        };
        return show(1,'查询成功', $res);
    }
    

    /**
     * 拒绝打款
     */
    public function reject($id)
    {
        \think\facade\Db::startTrans();
        try{

            $data =  \app\common\model\UserWithdrawal::where([
                'id'=>$id,
                'status'=>0,
            ])->find();
            if(!$data){
                return show(config('status.error'),'此订单不支持退回');
            }
            
            // 1.修改状态
            $data->status = 2;//拒绝
            $data->save();
            
            // 2.余额退回
            $res = \app\common\model\User::find($data->user_id)->inc('user_'.$data['type'], $data->amount)->save();

            // 记录余额流水
            \app\common\logic\AccountLogLogic::add(
                $data->user_id,
                \app\common\enum\AccountLogEnum::BNW_INC_CANCEL_ORDER,//提现退回
                \app\common\enum\AccountLogEnum::INC,
                $data->amount,
                $data->id,
            );
            
            \think\facade\Db::commit();

            return show(config('status.success'),'设置成功');
        }catch(\Exception $e){

            return show(config('status.error'),$e->getMessage());
        }
    }
}


