<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

/**
 * 首页导航菜单
 * Class GoodsController
 * @package app\adminapi\controller\goods
 */
class Share extends BaseAdminController
{
   
    /**
     * 分享列表
     */
    public function list()
    {
        $data = [
           // 默认标题
            'title'=>\app\common\service\ConfigService::get('share','title',''),
            // 默认描述
            'desc'=>\app\common\service\ConfigService::get('share','desc',''),
            // 默认分享图标
            'icon'=>\app\common\service\ConfigService::get('share','icon',''),

            // 图片提取规则最小高度
            'icon_min_height'=>\app\common\service\ConfigService::get('share','icon_min_height',''),
            // 图片提取规则最小宽度
            'icon_min_width'=>\app\common\service\ConfigService::get('share','icon_min_width',''),
            // 图片提取规则排除格式
            'icon_type_disable'=>\app\common\service\ConfigService::get('share','icon_type_disable',''),

            // 微信分享appid
            'appid'=>\app\common\service\ConfigService::get('share','appid',''),
            // 微信分享appsecrent
            'appsecrent'=>\app\common\service\ConfigService::get('share','appsecrent',''),
        ];

        return show(config('status.success'),'',$data);
        
    }

    public function set()
    {
        
        $params = $this->request->post();

        // 默认标题
        \app\common\service\ConfigService::set('share','title',$params['title']);
        // 默认描述
        \app\common\service\ConfigService::set('share','desc',$params['desc']);
        // 默认分享图标
        \app\common\service\ConfigService::set('share','icon',$params['icon']);

        // 图片提取规则最小高度
        \app\common\service\ConfigService::set('share','icon_min_height',$params['icon_min_height']);
        // 图片提取规则最小宽度
        \app\common\service\ConfigService::set('share','icon_min_width',$params['icon_min_width']);
        // 图片提取规则排除格式
        \app\common\service\ConfigService::set('share','icon_type_disable',$params['icon_type_disable']);

        // 微信分享appid
        \app\common\service\ConfigService::set('share','appid',$params['appid']);
        // 微信分享appsecrent
        \app\common\service\ConfigService::set('share','appsecrent',$params['appsecrent']);

        return show(config('status.success'),'设置成功');
    }
    
}


